#############################################################################
# LFS Lapper Multi-Page Help System by Krayy
#############################################################################
# This is a more flexible Help system that allows the addition of extra help
# descriptions without encroaching on available screen area.
#############################################################################
# Ver 1.0.1 - 15 Jan 2010 Initial release
# Ver 1.0.2 - 16 Jan 2010 Minor updates to display
# Ver 1.0.4 - 16 Feb 2010 Updated to support v 5.926b
# Ver 1.0.5 - 7 July 2010, Updated for common look & feel interface
#############################################################################

CatchEvent OnLapperStart()
	# CifRegisterModule("Group_Name", "Module Name", MODULE_VERSION);
	CifRegisterModule("Help", "Stats", "1.01");
EndCatchEvent

Sub DoCifHelpStats ( $KeyFlags, $id )
	# Set default values for the module - these MUST be the same as the main Do function name
	$cifGroupName="Help";
	$cifModuleName="Stats";
	$DialogPrefix = "CIF" . $cifGroupName . $cifModuleName . "_";

	# Draw the CIF dialog box
	CifDraw($cifGroupName, $cifModuleName, "Stats Help");
	openPrivButton ( $DialogPrefix . "help",$CifOrigL+1,$CifOrigT,98,6,5,-1,64,langEngine( "%{gui_help_contents_" . $cifModuleName . "}%") );
EndSub


Lang "EN" # Race Events messages
	gui_help_contents_Stats = "^2Track/Race Info"
			. "%nl%^3!distance ^8- Show track distance"
			. "%nl%^3!near [name] ^8- Show top 14 drivers near your ranking"
			. "%nl%^3!nearqual [name] ^8- Show top qualifiers near your time"
			. "%nl%^3!spb ^8- Show splits"
			. "%nl%^3!top [car] ^8- Show top drivers with this track/car"
			. "%nl%^3!topqual [car] ^8- Show top qual times with this car"
			. "%nl%^3!track ^8- Show current track information"
			. "%nl%"
			. "%nl%^2Drifting Info"
			. "%nl%^3!drf [name] ^8- "
			. "%nl%^3!drfnear [name] ^8- "
			. "%nl%^3!drfnearqual [name] ^8- "
			. "%nl%^3!drfqual [name] ^8- "
			. "%nl%^3!dstats [name] ^8- "
			. "%nl%^3!dstatsqual [name] ^8- "
			. "%nl%"
			. "%nl%^2LFSLapper Info"
			. "%nl%^3!time ^8- Show local server time"
			. "%nl%^3!powered ^8- Show Copyright Notice"
			. "%nl%^3!ver ^8- Show LFSLapper version";
EndLang
